Attribute VB_Name = "Drawing"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Function menuDrawLinearDimension()

'Get the application object
If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If



On Error GoTo NoDocErr

Dim doc As GraphicDocument
Set doc = prod.GetActiveDoc

On Error GoTo 0

If doc Is Nothing Then
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function
End If

If Not (TypeOf doc Is DrawingDocument) Then
    MsgBox "The Active document is not a Drawing"
    Exit Function
End If

MsgBox "Select a Drawing View"

Dim sel As ObjectSet
Set sel = doc.GetSelection("View")

If sel.IsEmpty Then
    MsgBox "No Views are selected"
    Exit Function
End If

Dim viewSetIt As Iterator
Set viewSetIt = prod.GetClass("It").CreateAObjectIt(sel)

If (sel.GetAnyMember.IsA("View")) Then
    If sel.GetCount > 1 Then
        MsgBox "More than one View selected"
        Exit Function
    End If
Else
    MsgBox "Improper Selection"
    Exit Function
End If

Dim view1 As aView
Set view1 = viewSetIt.start

'get the design
Dim Design As aDesign
Set Design = view1.GetDesign
If Design Is Nothing Then
    MsgBox "Could not get the Active design", vbExclamation, "Error"
    Exit Function
End If

MsgBox ("Select Two straight drawing feature items for linear dimension")
Dim Dummy As Object
Dim graphSet As ObjectSet
Set graphSet = doc.GetSelection("Graphic")

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

' draw Linear dimension
cfobject.DrawLinearDimension Design, doc, graphSet

api.CommitCalls "DrawLinearDimension", pause

Exit Function

NoDocErr:
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function

End Function



Function menuDrawAngularDimension()


'-------------------------------------------------------------------------------
'Get the application object
If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If


On Error GoTo NoDocErr

Dim doc As GraphicDocument
Set doc = prod.GetActiveDoc

On Error GoTo 0

If doc Is Nothing Then
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function
End If

If Not (TypeOf doc Is DrawingDocument) Then
    MsgBox "The Active document is not a Drawing"
    Exit Function
End If

MsgBox "Select a Drawing View"

Dim sel As ObjectSet
Set sel = doc.GetSelection("View")

If sel.IsEmpty Then
    MsgBox "No Views are selected"
    Exit Function
End If

If (sel.GetAnyMember.IsA("View")) Then
    If sel.GetCount > 1 Then
        MsgBox "More than one View selected"
        Exit Function
    End If
Else
    MsgBox "Improper Selection"
    Exit Function
End If

Dim view1 As aView
Set view1 = sel.GetAnyMember

'get the design
Dim Design As aDesign
Set Design = view1.GetDesign
If Design Is Nothing Then
    MsgBox "Could not get the Active design", vbExclamation, "Error"
    Exit Function
End If

MsgBox ("Select two straight drawing features for an Angular Dimension")
Dim graphSet As ObjectSet
Set graphSet = doc.GetSelection("Graphic")

Dim api As helm
Set api = prod.TakeHelm

' draw Linear dimension
cfobject.DrawAngularDimension Design, doc, graphSet

api.CommitCalls "DrawAngularDimension", pause

Exit Function

NoDocErr:
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function

End Function



Function menuDrawRadialDimension()

'Get the application object
If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

On Error GoTo NoDocErr

Dim doc As GraphicDocument
Set doc = prod.GetActiveDoc

On Error GoTo 0

If doc Is Nothing Then
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function
End If

If Not (TypeOf doc Is DrawingDocument) Then
    MsgBox "The Active document is not a Drawing"
    Exit Function
End If

MsgBox "Select a Drawing View"

Dim sel As ObjectSet
Set sel = doc.GetSelection("View")

If sel.IsEmpty Then
    MsgBox "No Views are selected"
    Exit Function
End If

If (sel.GetAnyMember.IsA("View")) Then
    If sel.GetCount > 1 Then
        MsgBox "More than one View selected"
        Exit Function
    End If
Else
    MsgBox "Improper Selection"
    Exit Function
End If

Dim view1 As aView
Set view1 = sel.GetAnyMember

'get the design
Dim Design As aDesign
Set Design = view1.GetDesign
If Design Is Nothing Then
    MsgBox "Could not get the Active design", vbExclamation, "Error"
    Exit Function
End If

MsgBox ("Select a circular drawing feature to create a Radial Dimension")
Dim graph As aGraphic
Set graph = doc.GetSingleSelection("Graphic")

Dim api As helm
Set api = prod.TakeHelm

' draw Radial dimension
cfobject.DrawRadialDimension Design, doc, graph

api.CommitCalls "DrawRadialDimension", pause

Exit Function

NoDocErr:
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function

End Function


Function menuDrawDiametricDimension()

'Get the application object
If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

On Error GoTo NoDocErr

Dim doc As GraphicDocument
Set doc = prod.GetActiveDoc

On Error GoTo 0

If doc Is Nothing Then
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function
End If

If Not (TypeOf doc Is DrawingDocument) Then
    MsgBox "The Active document is not a Drawing"
    Exit Function
End If

MsgBox "Select a Drawing View"

Dim sel As ObjectSet
Set sel = doc.GetSelection("View")

If sel.IsEmpty Then
    MsgBox "No Views are selected"
    Exit Function
End If

If (sel.GetAnyMember.IsA("View")) Then
    If sel.GetCount > 1 Then
        MsgBox "More than one View selected"
        Exit Function
    End If
Else
    MsgBox "Improper Selection"
    Exit Function
End If

Dim view1 As aView
Set view1 = sel.GetAnyMember

'get the design
Dim Design As aDesign
Set Design = view1.GetDesign
If Design Is Nothing Then
    MsgBox "Could not get the Active design", vbExclamation, "Error"
    Exit Function
End If

MsgBox ("Select a circular drawing feature to create a Diametric Dimension")
Dim graph As aGraphic
Set graph = doc.GetSingleSelection("Graphic")

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

' draw diametric dimension
cfobject.DrawDiametricDimension Design, doc, graph

api.CommitCalls "DrawDiametricDimension", pause

Exit Function

NoDocErr:
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function

End Function


Function menuDrawGeomTol()

'Get the application object
If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

On Error GoTo NoDocErr

Dim doc As GraphicDocument
Set doc = prod.GetActiveDoc

On Error GoTo 0

If doc Is Nothing Then
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function
End If

If Not (TypeOf doc Is DrawingDocument) Then
    MsgBox "The Active document is not a Drawing"
    Exit Function
End If

MsgBox "Select a Drawing View"

Dim sel As ObjectSet
Set sel = doc.GetSelection("View")

If sel.IsEmpty Then
    MsgBox "No Views are selected"
    Exit Function
End If

If (sel.GetAnyMember.IsA("View")) Then
    If sel.GetCount > 1 Then
        MsgBox "More than one View selected"
        Exit Function
    End If
Else
    MsgBox "Improper Selection"
    Exit Function
End If

Dim view1 As aView
Set view1 = sel.GetAnyMember

'get the design
Dim Design As aDesign
Set Design = view1.GetDesign
If Design Is Nothing Then
    MsgBox "Could not get the Active design", vbExclamation, "Error"
    Exit Function
End If

MsgBox ("Select a drawing feature to create a Geometric Tolerance")
Dim graph As aGraphic
Set graph = doc.GetSingleSelection("Graphic")

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

' draw geometric tolerance
cfobject.DrawGeomTol Design, doc, graph

api.CommitCalls "DrawGeomTol", pause

Exit Function

NoDocErr:
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function

End Function



Function menuDrawDatum()

'Get the application object
If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

On Error GoTo NoDocErr

Dim doc As GraphicDocument
Set doc = prod.GetActiveDoc

On Error GoTo 0

If doc Is Nothing Then
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function
End If

If Not (TypeOf doc Is DrawingDocument) Then
    MsgBox "The Active document is not a Drawing"
    Exit Function
End If

MsgBox "Select a Drawing View"

Dim sel As ObjectSet
Set sel = doc.GetSelection("View")

If sel.IsEmpty Then
    MsgBox "No Views are selected"
    Exit Function
End If

If (sel.GetAnyMember.IsA("View")) Then
    If sel.GetCount > 1 Then
        MsgBox "More than one View selected"
        Exit Function
    End If
Else
    MsgBox "Improper Selection"
    Exit Function
End If

Dim view1 As aView
Set view1 = sel.GetAnyMember

'get the design
Dim Design As aDesign
Set Design = view1.GetDesign
If Design Is Nothing Then
    MsgBox "Could not get the Active design", vbExclamation, "Error"
    Exit Function
End If

MsgBox ("Select a drawing feature to create a Datum")
Dim graph As aGraphic
Set graph = doc.GetSingleSelection("Graphic")

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

' draw a datum
cfobject.DrawDatum Design, doc, graph

api.CommitCalls "DrawDatum", pause

Exit Function

NoDocErr:
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function

End Function


Function menuDrawNote()

'Get the application object
If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

On Error GoTo NoDocErr

Dim doc As GraphicDocument
Set doc = prod.GetActiveDoc

On Error GoTo 0

If doc Is Nothing Then
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function
End If

If Not (TypeOf doc Is DrawingDocument) Then
    MsgBox "The Active document is not a Drawing"
    Exit Function
End If

MsgBox "Select a Drawing View"

Dim sel As ObjectSet
Set sel = doc.GetSelection("View")

If sel.IsEmpty Then
    MsgBox "No Views are selected"
    Exit Function
End If

If (sel.GetAnyMember.IsA("View")) Then
    If sel.GetCount > 1 Then
        MsgBox "More than one View selected"
        Exit Function
    End If
Else
    MsgBox "Improper Selection"
    Exit Function
End If

Dim view1 As aView
Set view1 = sel.GetAnyMember

'get the design
Dim Design As aDesign
Set Design = view1.GetDesign
If Design Is Nothing Then
    MsgBox "Could not get the Active design", vbExclamation, "Error"
    Exit Function
End If

MsgBox ("Select a drawing Feature in order to create a note")
Dim graph As aGraphic
Set graph = doc.GetSingleSelection("Graphic")

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

' draw a Note
cfobject.DrawNote Design, doc, graph

api.CommitCalls "DrawNote", pause

Exit Function

NoDocErr:
    MsgBox "Could not get the Active Drawing", vbExclamation, "Error"
    Exit Function

End Function

